onmessage = function (e) {
    function clamp(n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return Math.floor(n);
    }
    let R,
        G,
        B,
        Y = [],
        U = [],
        V = [];
    let arr = new Uint8Array(e.data);
    let i = 0;
    while (i < arr.length) {
        R = arr[i];
        G = arr[i + 1];
        B = arr[i + 2];
        Y.push(clamp((R * 0.257) + (G * 0.504) + (B * 0.098) + 16));
        U.push(clamp(-(R * 0.148) - (G * 0.291) + (B * 0.439) + 128));
        V.push(clamp((R * 0.439) - (G * 0.368) - (B * 0.071) + 128));
        i += 4;
    }

    let yuvArray = Y.concat(U).concat(V);

    let byteArr = new Uint8Array(yuvArray.length);
    i = 0;
    while (i < byteArr.length) {
        byteArr[i] = yuvArray[i];
        i++;
    }
    postMessage(byteArr.buffer, [byteArr.buffer]);
};