//----------------------------------------------------------------------------
//   The confidential and proprietary information contained in this file may
//   only be used by a person authorised under and to the extent permitted
//   by a subsisting licensing agreement from ARM Limited or its affiliates.
//
//          (C) COPYRIGHT 2017 ARM Limited or its affiliates.
//              ALL RIGHTS RESERVED
//
//   This entire notice must be reproduced on all copies of this file
//   and copies of this file may only be made by a person if such person is
//   permitted to do so under the terms of a subsisting license agreement
//   from ARM Limited or its affiliates.
//----------------------------------------------------------------------------
'use strict';

function hex(i) {
    return (i).toString(16);
}

class Scr {
    constructor() {
        this.content = ``;
    }

    write(lines) {
        for (let line of lines) {
            this.content += line + `\n`;
        }
    }
}


module.exports = {
    generate: function (configSize, inputWidth, inputHeight, inputFiles, outputWidth, outputHeight, outputFiles) {

        let scr = new Scr();

        scr.write([
            `wr gdc.gdc.config_addr 100000`,
            `wr gdc.gdc.config_size ${hex(configSize)}`,
            `wmb 100000 config.bin`,
            `wr gdc.gdc.datain_width ${hex(inputWidth)}`,
            `wr gdc.gdc.datain_height ${hex(inputHeight)}`
        ]);

        for (let i = 0; i < inputFiles.length; i++) {
            scr.write([
                `wr gdc.gdc.data${i + 1}in_addr ${1000000 * (i + 1)}`,
                `wr gdc.gdc.data${i + 1}in_line_offset ${hex(inputFiles[i].width)}`,
                `wmb ${1000000 * (i + 1)} ${hex(inputFiles[i].name)}`
            ]);
        }

        scr.write([
            `wr gdc.gdc.dataout_width ${hex(outputWidth)}`,
            `wr gdc.gdc.dataout_height ${hex(outputHeight)}`
        ]);

        for (let i = 0; i < outputFiles.length; i++) {
            scr.write([
                `wr gdc.gdc.data${i + 1}out_addr ${(i * 1000000) + 4000000}`,
                `wr gdc.gdc.data${i + 1}out_line_offset ${hex(outputFiles[i].width)}`
            ]);
        }

        scr.write([
            `wr gdc.gdc.config 1`,
            `process`,
            `wr gdc.gdc.config 0`
        ]);

        for (let i = 0; i < outputFiles.length; i++) {
            scr.write([
                `rmb ${(i * 1000000) + 4000000} ${hex(outputFiles[i].size)} ${outputFiles[i].name}`,
            ]);
        }

        return scr.content;

    }
};

