"use strict";(self.webpackChunkrspress_doc_template=self.webpackChunkrspress_doc_template||[]).push([["4271"],{3418:function(e,s,n){n.r(s);var i=n(85893),l=n(50065);function r(e){let s=Object.assign({h1:"h1",a:"a",p:"p",ol:"ol",li:"li",code:"code",h2:"h2",div:"div",br:"br",ul:"ul",pre:"pre",span:"span",h3:"h3",table:"table",thead:"thead",tr:"tr",th:"th",strong:"strong",tbody:"tbody",td:"td"},(0,l.ah)(),e.components);return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsxs)(s.h1,{id:"advanced-development",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#advanced-development",children:"#"}),"Advanced Development"]}),"\n",(0,i.jsx)(s.p,{children:"In this chapter, we will introduce the advanced development workflow of D-Robotics-LLM."}),"\n",(0,i.jsx)(s.p,{children:"This workflow applies to the following scenarios:"}),"\n",(0,i.jsxs)(s.ol,{children:["\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"The model has already been fine-tuned and requires re-quantization."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Simple single-turn conversations."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Continuous multi-turn conversations, where the model can remember questions and answers from previous rounds."}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsx)(s.p,{children:"Calculating the model's Perplexity (PPL) metric on the edge device."}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.p,{children:["For the above scenarios, we will use the ",(0,i.jsx)(s.code,{children:"DeepSeek-R1-Distill-Qwen-1.5B"})," model as an example to illustrate usage."]}),"\n",(0,i.jsxs)(s.h2,{id:"environment-setup",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#environment-setup",children:"#"}),"Environment Setup"]}),"\n",(0,i.jsxs)(s.p,{children:["Please ensure you have correctly completed environment setup for both the development host and development board according to the ",(0,i.jsx)(s.a,{href:"/latest/en/guide/env_install.html",children:"Environment Deployment"})," section."]}),"\n",(0,i.jsxs)(s.h2,{id:"deployment-package-preparation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#deployment-package-preparation",children:"#"}),"Deployment Package Preparation"]}),"\n",(0,i.jsxs)(s.p,{children:["Download the provided ",(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}.tar.gz"})," deployment package and extract it."]}),"\n",(0,i.jsxs)(s.h2,{id:"model-preparation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model-preparation",children:"#"}),"Model Preparation"]}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive warning",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["Currently, only the ",(0,i.jsx)(s.code,{children:"DeepSeek-R1-Distill-Qwen-1.5B"})," and ",(0,i.jsx)(s.code,{children:"DeepSeek-R1-Distill-Qwen-7B"})," models are supported.",(0,i.jsx)(s.br,{}),"\n","Before downloading a model, please ensure you understand its license terms, dependency requirements, and other necessary information to guarantee proper subsequent usage."]})})]}),"\n",(0,i.jsx)(s.p,{children:"You can obtain DeepSeek series models via the Hugging Face platform. Below are the download links:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.a,{href:"https://huggingface.co/deepseek-ai/DeepSeek-R1-Distill-Qwen-1.5B",target:"_blank",rel:"noopener noreferrer",children:"DeepSeek-R1-Distill-Qwen-1.5B model"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.a,{href:"https://huggingface.co/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B",target:"_blank",rel:"noopener noreferrer",children:"DeepSeek-R1-Distill-Qwen-7B model"})}),"\n"]}),"\n",(0,i.jsxs)(s.h2,{id:"model_quantization",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#model_quantization",children:"#"}),"Model Quantization"]}),"\n",(0,i.jsxs)(s.p,{children:["D-Robotics-LLM provides command-line tools to quantize and compile models for edge devices. Here, we demonstrate using the ",(0,i.jsx)(s.code,{children:"DeepSeek-R1-Distill-Qwen-1.5B"})," model with the following reference command:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"oellm_build"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--model_name"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"deepseek-qwen-1_5b"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--input_model_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./DeepSeek-R1-Distill-Qwen-1.5B"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--output_model_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./output_hbm"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--march"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"nash-m"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"  \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--chunk_size"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--cache_len"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"4096"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsx)(s.div,{className:"rspress-directive-content",children:(0,i.jsxs)(s.p,{children:["For detailed usage instructions and precautions regarding the ",(0,i.jsx)(s.code,{children:"oellm_build"})," tool, please refer to the ",(0,i.jsx)(s.a,{href:"/latest/en/guide/tool_introduction/oellm_build.html",children:"oellm_build Tool"})," section."]})})]}),"\n",(0,i.jsxs)(s.p,{children:["If you obtain our pre-compiled ",(0,i.jsx)(s.code,{children:".hbm"})," models via the links provided in ",(0,i.jsx)(s.code,{children:"resolve_model.txt"}),", you may skip this quantization step."]}),"\n",(0,i.jsxs)(s.p,{children:["All ",(0,i.jsx)(s.code,{children:"DeepSeek"})," models listed in ",(0,i.jsx)(s.code,{children:"resolve_model.txt"})," were compiled with ",(0,i.jsx)(s.code,{children:"chunk_size=256"})," and two different ",(0,i.jsx)(s.code,{children:"cache_len"})," configurations (",(0,i.jsx)(s.code,{children:"1024"})," and ",(0,i.jsx)(s.code,{children:"4096"}),"). This difference is reflected in their filenames."]}),"\n",(0,i.jsxs)(s.h2,{id:"edge-device-runtime-preparation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#edge-device-runtime-preparation",children:"#"}),"Edge Device Runtime Preparation"]}),"\n",(0,i.jsxs)(s.p,{children:["In the directory ",(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}/oellm_runtime/example"}),", we have pre-prepared compiled executables in respective subdirectories that can be directly run on the edge device. Alternatively, you can execute different build scripts to generate required files yourself. Reference commands are as follows:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Simple conversation"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"sh"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_oellm_run.sh"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Multi-turn conversation"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"sh"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_oellm_multichat.sh"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# PPL evaluation"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"sh"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"build_oellm_ppl.sh"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Next, create a working directory on the edge device with the following command:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Running on S100/S100P"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"mkdir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-p"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/home/root/llm"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Before deploying to the board, ensure you have prepared the following:"}),"\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:"A functional development board for running programs."}),"\n",(0,i.jsxs)(s.li,{children:["A deployable model file (",(0,i.jsx)(s.code,{children:"*.hbm"}),"), which is the output from ",(0,i.jsx)(s.a,{href:"#model_quantization",children:"Model Quantization"}),"."]}),"\n",(0,i.jsxs)(s.li,{children:["Executable files (",(0,i.jsx)(s.code,{children:"oellm_run"}),", ",(0,i.jsx)(s.code,{children:"oellm_multichat"}),", and ",(0,i.jsx)(s.code,{children:"oellm_ppl"}),")."]}),"\n",(0,i.jsxs)(s.li,{children:["Runtime dependency libraries. To reduce deployment overhead, you can directly use the contents from the following directories within the D-Robotics-LLM package:","\n",(0,i.jsxs)(s.ul,{children:["\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}/oellm_runtime/set_performance_mode.sh"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}/oellm_runtime/lib"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}/oellm_runtime/config"})}),"\n",(0,i.jsx)(s.li,{children:(0,i.jsx)(s.code,{children:"D-Robotics_LLM_{version}/oellm_runtime/example"})}),"\n"]}),"\n"]}),"\n"]}),"\n",(0,i.jsxs)(s.p,{children:["After preparation, organize your model files (",(0,i.jsx)(s.code,{children:"*.hbm"}),"), executables, and dependencies into a unified directory structure as shown below:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"root@ubuntu:/home/root/llm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- model"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- resolve_model.txt"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_1.5B_1024.hbm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_1.5B_1024_q4.hbm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_1.5B_4096.hbm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_1.5B_4096_q4.hbm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_7B_1024.hbm"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- config"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_1.5B_config"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- DeepSeek_R1_Distill_Qwen_7B_config"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- example"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- oellm_run"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- oellm_run"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- oellm_multichat"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- oellm_multichat"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- deepseek_multichat_config.json"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |-- oellm_ppl"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- oellm_ppl"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- deepseek_ppl_config.json"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|   |   |-- test-00000-of-00001.bin"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- include"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"|-- lib"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"`--set_performance_mode.sh"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsx)(s.p,{children:"Copy the integrated folder from your development host to the edge device directory using the following command:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"scp"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-r"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"llm/*"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"root@{board_ip}:/home/root/llm"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.p,{children:["Finally, configure ",(0,i.jsx)(s.code,{children:"LD_LIBRARY_PATH"})," under ",(0,i.jsx)(s.code,{children:"/home/root/llm/D-Robotics_LLM_{version}/oellm_runtime"})," with the following commands:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Modify hardware registers to switch the device to performance mode"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"sh"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"set_performance_mode.sh"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-comment)"},children:"# Set environment variables"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"lib"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"/home/root/llm/lib"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"export"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" LD_LIBRARY_PATH"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${lib}"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"${LD_LIBRARY_PATH}"})]}),"\n"]})})}),"\n",(0,i.jsxs)(s.h2,{id:"running-on-edge-device",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#running-on-edge-device",children:"#"}),"Running on Edge Device"]}),"\n",(0,i.jsxs)(s.h3,{id:"simple-conversation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#simple-conversation",children:"#"}),"Simple Conversation"]}),"\n",(0,i.jsx)(s.p,{children:"Reference command for running on the edge device:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./example/oellm_run"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"./oellm_run"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--hbm_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"../../model/DeepSeek_R1_Distill_Qwen_1.5B_4096.hbm"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--tokenizer_dir"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"../../config/DeepSeek_R1_Distill_Qwen_1.5B_config/"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--template_path"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"../../config/DeepSeek_R1_Distill_Qwen_1.5B_config/DeepSeek_R1_Distill_Qwen_1.5B.jinja"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" \\"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"            "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"--model_type"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Program input parameters are as follows:"}),"\n",(0,i.jsxs)(s.table,{children:[(0,i.jsx)(s.thead,{children:(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Parameter"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Description"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Optional/Required"})})]})}),(0,i.jsxs)(s.tbody,{children:[(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"-h, --help"})}),(0,i.jsx)(s.td,{children:"Display help information."}),(0,i.jsx)(s.td,{children:"/"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"--hbm_path"})}),(0,i.jsxs)(s.td,{children:["Path to the quantized model file (",(0,i.jsx)(s.code,{children:"*.hbm"}),")."]}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"--tokenizer_dir"})}),(0,i.jsx)(s.td,{children:"Path to tokenizer configuration."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"--template_path"})}),(0,i.jsx)(s.td,{children:"Path to conversation template."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"--model_type"})}),(0,i.jsxs)(s.td,{children:["Specifies the model type; currently, DeepSeek models use type ",(0,i.jsx)(s.code,{children:"1"}),"."]}),(0,i.jsx)(s.td,{children:"Required"})]})]})]}),"\n",(0,i.jsxs)(s.h3,{id:"multi-turn-conversation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#multi-turn-conversation",children:"#"}),"Multi-turn Conversation"]}),"\n",(0,i.jsx)(s.p,{children:"Reference command for running on the edge device:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./example/oellm_multichat"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"./oellm_multichat"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-c"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./deepseek_multichat_config.json"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Program input parameters are as follows:"}),"\n",(0,i.jsxs)(s.table,{children:[(0,i.jsx)(s.thead,{children:(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Parameter"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Description"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Optional/Required"})})]})}),(0,i.jsxs)(s.tbody,{children:[(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"-h, --help"})}),(0,i.jsx)(s.td,{children:"Display help information."}),(0,i.jsx)(s.td,{children:"/"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"-c, --config"})}),(0,i.jsx)(s.td,{children:"Path to the JSON configuration file."}),(0,i.jsx)(s.td,{children:"Required"})]})]})]}),"\n",(0,i.jsx)(s.p,{children:"Example JSON configuration file:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-json",meta:'title="deepseek_multichat_config.json"',children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"{"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"hbm_path"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"../../model/DeepSeek_R1_Distill_Qwen_1.5B_4096.hbm"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"tokenizer_dir"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"../../config/deepseek_config/"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"template_path"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"../../config/deepseek_config/DeepSeek-R1-Distill-Qwen-1.5B.jinja"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_type"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"JSON configuration parameters are described below:"}),"\n",(0,i.jsxs)(s.table,{children:[(0,i.jsx)(s.thead,{children:(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Parameter"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Description"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Optional/Required"})})]})}),(0,i.jsxs)(s.tbody,{children:[(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"hbm_path"})}),(0,i.jsxs)(s.td,{children:["Path to the quantized model file (",(0,i.jsx)(s.code,{children:"*.hbm"}),")."]}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"tokenizer_dir"})}),(0,i.jsx)(s.td,{children:"Path to tokenizer configuration."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"template_path"})}),(0,i.jsx)(s.td,{children:"Path to conversation template."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"bpu_core"})}),(0,i.jsxs)(s.td,{children:["Specifies the BPU core to use. Default value is ",(0,i.jsx)(s.code,{children:"-1"}),", meaning any core."]}),(0,i.jsx)(s.td,{children:"Optional"})]})]})]}),"\n",(0,i.jsxs)(s.h3,{id:"ppl-evaluation",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#ppl-evaluation",children:"#"}),"PPL Evaluation"]}),"\n",(0,i.jsx)(s.p,{children:"To evaluate the model's PPL (Perplexity) on the device, refer to the following commands:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-bash",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"cd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./example/oellm_ppl"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"./oellm_ppl"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"-c"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string)"},children:"./deepseek_ppl_config.json"})]}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"The program accepts the following input arguments:"}),"\n",(0,i.jsxs)(s.table,{children:[(0,i.jsx)(s.thead,{children:(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Argument"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Description"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Optional/Required"})})]})}),(0,i.jsxs)(s.tbody,{children:[(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"-h, --help"})}),(0,i.jsx)(s.td,{children:"Display help information."}),(0,i.jsx)(s.td,{children:"/"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"-c, --config"})}),(0,i.jsx)(s.td,{children:"Specify the path to the JSON configuration file."}),(0,i.jsx)(s.td,{children:"Required"})]})]})]}),"\n",(0,i.jsx)(s.p,{children:"Example of the JSON configuration file:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-json",meta:'title="deepseek_ppl_config.json"',children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"{"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"hbm_path"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"../../model/DeepSeek_R1_Distill_Qwen_1.5B_4096.hbm"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"tokenizer_dir"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"../../config/DeepSeek_R1_Distill_Qwen_1.5B_config/"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"model_type"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"1"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"ppl_testcase"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"test-00000-of-00001.bin"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"load_ckpt"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"false"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"text_data_num"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"max_length"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"stride"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,i.jsx)(s.p,{children:"Descriptions of the JSON configuration parameters are as follows:"}),"\n",(0,i.jsxs)(s.table,{children:[(0,i.jsx)(s.thead,{children:(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Parameter"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Description"})}),(0,i.jsx)(s.th,{children:(0,i.jsx)(s.strong,{children:"Optional/Required"})})]})}),(0,i.jsxs)(s.tbody,{children:[(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"hbm_path"})}),(0,i.jsxs)(s.td,{children:["Specifies the path to the quantized model file (",(0,i.jsx)(s.code,{children:"*.hbm"}),")."]}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"tokenizer_dir"})}),(0,i.jsx)(s.td,{children:"Specifies the path to the tokenizer configuration."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"model_type"})}),(0,i.jsx)(s.td,{children:"Specifies the model type to run. The current DeepSeek model type is 1."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"ppl_testcase"})}),(0,i.jsxs)(s.td,{children:["Specifies the path to the test file. Currently, only ",(0,i.jsx)(s.code,{children:"bin"})," format is supported."]}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"max_length"})}),(0,i.jsx)(s.td,{children:"Specifies the sequence length fed into the model each time."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"stride"})}),(0,i.jsx)(s.td,{children:"Specifies the stride length used during evaluation."}),(0,i.jsx)(s.td,{children:"Required"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"bpu_core"})}),(0,i.jsxs)(s.td,{children:["Specifies the BPU core to use. Default value is ",(0,i.jsx)(s.code,{children:"-1"}),", meaning any core."]}),(0,i.jsx)(s.td,{children:"Optional"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"load_ckpt"})}),(0,i.jsxs)(s.td,{children:["Whether to resume testing from the last interruption point. Default value is ",(0,i.jsx)(s.code,{children:"false"}),"."]}),(0,i.jsx)(s.td,{children:"Optional"})]}),(0,i.jsxs)(s.tr,{children:[(0,i.jsx)(s.td,{children:(0,i.jsx)(s.code,{children:"text_data_num"})}),(0,i.jsxs)(s.td,{children:["Specifies truncating the input text to a specific length before testing. If ",(0,i.jsx)(s.code,{children:"text_data_num <= 0"}),", no truncation occurs. Default value is ",(0,i.jsx)(s.code,{children:"0"}),"."]}),(0,i.jsx)(s.td,{children:"Optional"})]})]})]}),"\n",(0,i.jsxs)(s.h2,{id:"execution-results",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#execution-results",children:"#"}),"Execution Results"]}),"\n",(0,i.jsxs)(s.h3,{id:"simple-conversation-1",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#simple-conversation-1",children:"#"}),"Simple Conversation"]}),"\n",(0,i.jsx)(s.p,{children:"Example of a simple conversation test:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[User] <<< Briefly describe the development of artificial intelligence."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[Assistant] >>> <\uFF5Cbegin\u2581of\u2581sentence\uFF5C>"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"The development of Artificial Intelligence (AI) can be divided into several key stages:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"1. **Early AI**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Artificial Intelligence**: Initially applied to specific tasks such as gaming and customer service."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Machine Learning**: In the 1950s, computers began learning tasks like automatic recognition and speech recognition."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Expert Systems**: In the 1970s, systems like \u201CMYCIN\u201D simulated human experts."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"2. **Computer Vision**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Image Recognition**: In the 1980s, computers recognized simple images, such as handwritten digits."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Natural Language Processing**: In the 1990s, systems performed tasks like automated Wikipedia search and editing."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"3. **Deep Learning**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Neural Networks**: In the 1980s, neural networks started processing complex data."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Convolutional Neural Networks (CNNs)**: In the 1990s, CNNs were used for image recognition, e.g., in autonomous vehicles."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Deep Learning**: In the 2010s, models like GPT and BERT revolutionized natural language processing."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"4. **Reinforcement Learning**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Robotics Control**: In the 1980s, robots learned actions through trial and error."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Autonomous Driving**: In the 2010s, reinforcement learning enabled self-driving cars."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"5. **Deep Learning and Neural Networks**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Image Recognition**: Including classification, segmentation, and generation."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Natural Language Processing**: Including text generation, translation, and dialogue."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Speech Recognition**: Including transcription and speech synthesis."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"6. **AI Applications**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Healthcare**: Such as diagnostics and drug discovery."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Transportation**: Including autonomous driving and traffic management systems."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Education**: Such as intelligent tutoring systems."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Finance**: Including algorithmic trading and risk management."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"7. **Ethics and Challenges**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Privacy Issues**: Data breaches and privacy violations."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Ethical Concerns**: Algorithmic bias and fairness issues."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"8. **Future Outlook**:"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **AI Chips**: Dedicated hardware for training and inference."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Edge AI**: Running AI directly on devices to reduce data transmission."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Multimodal AI**: Integrating vision, audio, and other modalities."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"   - **Human Assistants**: Including chatbots and life-support systems."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"AI will continue advancing across multiple domains, driving technological progress and societal transformation."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"Performance prefill: 2348.62 tokens/s    decode: 27.08 tokens/s"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsxs)(s.h3,{id:"multi-turn-dialogue",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#multi-turn-dialogue",children:"#"}),"Multi-turn Dialogue"]}),"\n",(0,i.jsx)(s.p,{children:"Example of a multi-turn dialogue test:"}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-text",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[User] <<< Briefly introduce the current state of AI development."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[Assistant] >>> <\uFF5Cbegin\u2581of\u2581sentence\uFF5C>"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"AI technology has entered a phase of rapid advancement. From basic speech recognition to complex image understanding, from natural language processing to reinforcement learning, the boundaries of AI continue expanding. These technologies have been widely adopted in healthcare, education, finance, and many other fields. Meanwhile, issues concerning AI explainability and ethics are increasingly drawing attention. In the future, as technology progresses further, AI will evolve toward greater intelligence and human-like interaction."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"Performance prefill: 2347.63 tokens/s    decode: 27.06 tokens/s"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[User] <<< How can robotics integrate with this field?"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"[Assistant] >>> <\uFF5Cbegin\u2581of\u2581sentence\uFF5C>"})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"The integration of AI and robotics enables smarter and more efficient solutions. For example, robots can perform complex tasks in specialized domains\u2014such as surgical simulation in healthcare or automated manufacturing in industry. AI can optimize robotic behaviors to enhance efficiency, while robots effectively execute decisions generated by AI. This synergy will expand robotics into broader application areas. At the same time, ethical considerations must be carefully addressed throughout this process. Through collaborative efforts between AI and robotics, humans can better navigate complex and uncertain environments, achieving more efficient and intelligent outcomes."})}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"Performance prefill: 2338.42 tokens/s    decode: 27.01 tokens/s"})}),"\n",(0,i.jsx)(s.span,{className:"line",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"}})})]})})}),"\n",(0,i.jsxs)(s.h3,{id:"ppl-evaluation-1",children:[(0,i.jsx)(s.a,{className:"header-anchor","aria-hidden":"true",href:"#ppl-evaluation-1",children:"#"}),"PPL Evaluation"]}),"\n",(0,i.jsxs)(s.p,{children:["After completing the PPL evaluation, a ",(0,i.jsx)(s.code,{children:"{ppl_testcase}.json"})," file will be generated in the same directory. The value corresponding to ",(0,i.jsx)(s.code,{children:"Perplexity"})," in this file represents the final PPL result. Example output:"]}),"\n",(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-json",meta:"",children:[(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"{"})}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"PPL Parameters"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" {"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"hbm_path"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"DeepSeek_R1_Distill_Qwen_7B_1024.hbm"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"ppl_testcase"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"test-00000-of-00001.bin"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"text_data_num"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"0"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"max_length"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"256"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"        "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"stride"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"100"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    }"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"Average Negative Log-Likelihood"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"3.5173572962692465"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:","})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:'"Perplexity"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-constant)"},children:"33.69526409810056"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number",children:(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"}"})}),"\n"]})})}),"\n",(0,i.jsxs)(s.div,{className:"rspress-directive info",children:[(0,i.jsx)(s.div,{className:"rspress-directive-title",children:"Note"}),(0,i.jsxs)(s.div,{className:"rspress-directive-content",children:[(0,i.jsxs)(s.ol,{children:["\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["PPL evaluation supports resuming from checkpoints. During execution, the program generates a ",(0,i.jsx)(s.code,{children:"ppl_ckpt.json"})," file in the working directory. When ",(0,i.jsx)(s.code,{children:"load_ckpt"})," is set to ",(0,i.jsx)(s.code,{children:"true"}),", the program reads this file and resumes testing from the interruption point."]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["After the PPL program finishes execution, a JSON file containing key test parameters and the PPL result will be generated in the same directory as the ",(0,i.jsx)(s.code,{children:"bin"})," test file."]}),"\n"]}),"\n",(0,i.jsxs)(s.li,{children:["\n",(0,i.jsxs)(s.p,{children:["The ",(0,i.jsx)(s.code,{children:"bin"})," file specified by the ",(0,i.jsx)(s.code,{children:"ppl_testcase"})," parameter can be converted from a ",(0,i.jsx)(s.code,{children:"parquet"})," file. An example script ",(0,i.jsx)(s.code,{children:"convert_parquet_to_bin.py"})," is provided below:"]}),"\n"]}),"\n"]}),(0,i.jsx)(s.pre,{className:"code",children:(0,i.jsx)(s.pre,{className:"shiki css-variables has-line-number",style:{backgroundColor:"var(--shiki-color-background)"},tabIndex:"0",children:(0,i.jsxs)(s.code,{className:"language-python",meta:"",children:[(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" pandas "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" pd"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"from"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" datasets "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"import"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" Dataset"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"df "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" pd"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"read_parquet"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"test-00000-of-00001.parquet"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"dataset_test "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" Dataset"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"from_pandas"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(df)"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"text_data "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"="}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"\\n\\n"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"join"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(dataset_test["}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:"'text'"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"])"})]}),"\n",(0,i.jsx)(s.span,{className:"line line-number"}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"with"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"open"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"test-00000-of-00001.bin"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:", "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"wb"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:")"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" "}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-keyword)"},children:"as"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:" f"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:":"})]}),"\n",(0,i.jsxs)(s.span,{className:"line line-number",children:[(0,i.jsx)(s.span,{style:{color:"var(--shiki-color-text)"},children:"    f"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"write"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"(text_data."}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-function)"},children:"encode"}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"("}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-string-expression)"},children:'"utf-8"'}),(0,i.jsx)(s.span,{style:{color:"var(--shiki-token-punctuation)"},children:"))"})]}),"\n"]})})})]})]})]})}function o(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{wrapper:s}=Object.assign({},(0,l.ah)(),e.components);return s?(0,i.jsx)(s,Object.assign({},e,{children:(0,i.jsx)(r,e)})):r(e)}s.default=o,o.__RSPRESS_PAGE_META={},o.__RSPRESS_PAGE_META["latest%2Fen%2Fguide%2Fquickstart%2FS100P%2Fdeepseek_r1_distill_qwen%2Fadvanced_development_deepseek.mdx"]={toc:[{id:"environment-setup",text:"Environment Setup",depth:2},{id:"deployment-package-preparation",text:"Deployment Package Preparation",depth:2},{id:"model-preparation",text:"Model Preparation",depth:2},{id:"model_quantization",text:"Model Quantization",depth:2},{id:"edge-device-runtime-preparation",text:"Edge Device Runtime Preparation",depth:2},{id:"running-on-edge-device",text:"Running on Edge Device",depth:2},{id:"simple-conversation",text:"Simple Conversation",depth:3},{id:"multi-turn-conversation",text:"Multi-turn Conversation",depth:3},{id:"ppl-evaluation",text:"PPL Evaluation",depth:3},{id:"execution-results",text:"Execution Results",depth:2},{id:"simple-conversation-1",text:"Simple Conversation",depth:3},{id:"multi-turn-dialogue",text:"Multi-turn Dialogue",depth:3},{id:"ppl-evaluation-1",text:"PPL Evaluation",depth:3}],title:"Advanced Development",frontmatter:{}}}}]);